use mavenfuzzyfactory;

-- 1. Yêu cầu 1 – Khảo sát nguồn lưu lượng
select utm_source, utm_campaign, http_referer, count(distinct website_session_id) as number_session
from website_sessions
where created_at < '2012-04-12'
group by utm_source, utm_campaign, http_referer;

-- 2. Yêu cầu 2 - Tỷ lệ chuyển đổi từ nguồn lưu lượng truy cập
select count(distinct w.website_session_id) sessions, count(distinct o.order_id) orders,
	count(distinct o.order_id)/count(distinct w.website_session_id) as session_to_order_conv_rt
from website_sessions w
	left join orders o
    on w.website_session_id = o.website_session_id
where w.created_at < '2012-04-12'
	and utm_source='gsearch' and utm_campaign='nonbrand';

DELIMITER ;;
CREATE FUNCTION FIRST_DAY_OF_WEEK(day DATE)
RETURNS DATE DETERMINISTIC
BEGIN
  RETURN SUBDATE(day, WEEKDAY(day));
END;;
DELIMITER ;


-- 3. Yêu cầu 3 - Xu hướng nguồn lưu lượng truy cập
-- DATE_SUB(date(created_at), INTERVAL (DAYOFWEEK(created_at) - 1) DAY)
select first_day_of_week(created_at) as week_started_at, count(*) as sessions
from website_sessions
where utm_source='gsearch' and utm_campaign='nonbrand'
	and created_at < '2012-05-15'
group by week_started_at;

-- 4. Yêu cầu 4 – Tối ưu hoá bid cho các lưu lượng có trả tiền
select w.device_type, count(distinct o.order_id) orders,
	count(distinct o.order_id)/count(distinct w.website_session_id) as conv_rt
from website_sessions w
	left join orders o
    on w.website_session_id = o.website_session_id
where w.created_at < '2012-05-11'
group by w.device_type;

-- 5. Yêu cầu 5 – Kiểm tra kết quả khi tăng bid
select first_day_of_week(created_at) week_started_at,
	sum(case device_type when "desktop" then 1 else 0 end) as desktop_sessions,
	sum(case device_type when "mobile" then 1 else 0 end) as mobile_sessions
from website_sessions
where utm_source='gsearch' and utm_campaign='nonbrand'
	and created_at >= '2012-04-15'
group by week_started_at;

